import { useState } from "react";

import styled from "styled-components";

import imageHeader from "../../assets/images/image-header.png";
import imageHeader2 from "../../assets/images/image-header-2.png";
import imageHeader3 from "../../assets/images/image-header-3.png";

import Link from "../../components/atoms/Link/Link";
import Title from "../../components/atoms/Title/Title";
import Paragraph from "../../components/atoms/Paragraph/Paragraph";
import Carusel from "../../components/molecules/Carusel/Carusel";

const Wrapper = styled.header`
  width: 100vw;
  height: 100vh;
`;

const WrapperImages = styled.div`
  overflow: hidden;
  width: 100%;
  height: 100%;

  position: absolute;
  top: 0;
  left: 0;

  z-index: -1;
`;

const WrapperText = styled.div`
  position: relative;
  top: 280px;
  left: 200px;
  width: 30%;
  z-index: 1;

  @media (max-width: 600px) {
    margin: 100px auto 0;
    width: 100%;
    transform: translate(-40%, -50%);
    text-align: center;
  }
`;

const StyledTitle = styled(Title)``;

const StyledParagraph = styled(Paragraph)``;

const WrapperButton = styled.div`
  margin-top: 50px;
`;
const StyledLink = styled(Link)`
  margin-top: 25px;
`;

const Header = () => {
  const [allImage] = useState([imageHeader, imageHeader2, imageHeader3]);

  return (
    <Wrapper>
      <WrapperImages>
        <Carusel elements={allImage} />
      </WrapperImages>
      <WrapperText>
        <StyledTitle>Lorem ipsum, dolor sit amet</StyledTitle>
        <StyledParagraph>Lorem ipsum dolor sit amet</StyledParagraph>
        <WrapperButton>
          <StyledLink href="#" type="button">
            Get A Quote
          </StyledLink>
          <StyledLink href="#">Find out more</StyledLink>
        </WrapperButton>
      </WrapperText>
    </Wrapper>
  );
};

export default Header;
