import styled from "styled-components";

import { theme } from "../../theme";

import Title from "../../components/atoms/Title/Title";
import FormMessage from "../../components/molecules/Form/FormMessage";
import Paragraph from "../../components/atoms/Paragraph/Paragraph";

import BGImage from "../../assets/images/world.jpg";
import LocationSVG from "../../assets/svg/location.svg";
import MailSVG from "../../assets/svg/mail.svg";

const Wrapper = styled.section`
  position: relative;
  display: flex;
  padding: 90px 140px;
  background-color: ${theme.backgroundColors.secondary};
  z-index: 1;
  justify-content: center;

  :before {
    content: "";
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 10%;
    z-index: -1;

    background-image: url(${({ image }) => image});

    background-size: contain;
    background-repeat: no-repeat;
  }

  @media (max-width: 600px) {
    flex-direction: column;
    padding: 0;
  } ;
`;

const StyledTextWrapper = styled.div`
  flex-basis: 40%;
  @media (max-width: 600px) {
    padding: 60px 40px;
  } ;
`;

const WrapperContact = styled.div`
  margin: 0 auto;
`;

const WrapperElementContact = styled.div`
  display: flex;
  align-items: center;
  margin: 50px 0;

  @media (max-width: 600px) {
  }

  :before {
    display: block;
    content: " ";
    background-image: url(${({ image }) => image});
    background-size: 56px 56px;
    height: 56px;
    width: 56px;
    margin-right: 50px;
    @media (max-width: 600px) {
      margin-right: 20px;
    }
  }
`;

const StyledTitle = styled(Title)`
  color: ${theme.fontColors.tertiary};
  @media (max-width: 600px) {
    text-align: center;
  } ;
`;

const StyledParagraph = styled(Paragraph)`
  color: ${theme.fontColors.textAddress};
  font-size: 20px;
  margin: 9px 0;
`;
const StyledParagraphTitle = styled(StyledParagraph)`
  color: ${theme.fontColors.tertiary};
  font-size: 24px;
  font-weight: ${theme.fontWeight.medium};
  margin: 15px 0;
`;

const WrapperForm = styled.div`
  flex-basis: 40%;
`;

const Contact = () => {
  return (
    <Wrapper id="contact" image={BGImage}>
      <StyledTextWrapper>
        <WrapperContact>
          <StyledTitle type="h2">Lorem Ipsum</StyledTitle>{" "}
          <WrapperElementContact image={MailSVG}>
            <div>
              <StyledParagraphTitle type="text">
                CONTACT INFORMATION
              </StyledParagraphTitle>
              <StyledParagraph type="text">Phone: 500-500-5000</StyledParagraph>
              <StyledParagraph type="text">
                Email: contact@nexus.ca
              </StyledParagraph>
            </div>
          </WrapperElementContact>
          <WrapperElementContact image={LocationSVG}>
            <div>
              <StyledParagraphTitle type="text">Adress</StyledParagraphTitle>
              <StyledParagraph type="text">
                Montreal Montreal Montreal
              </StyledParagraph>
              <StyledParagraph type="text">
                Montreal Montreal Montreal 225
              </StyledParagraph>
            </div>
          </WrapperElementContact>
        </WrapperContact>
      </StyledTextWrapper>
      <WrapperForm>
        <FormMessage />
      </WrapperForm>
    </Wrapper>
  );
};

export default Contact;
