import styled from "styled-components";
import Paragraph from "../../components/atoms/Paragraph/Paragraph";
import Title from "../../components/atoms/Title/Title";

import ImageBgc from "../../assets/images/map-bg.jpg";

const Wrapper = styled.section`
  /* background-color: red; */
  background-image: url(${({ image }) => image});
  background-position: center;
  background-repeat: no-repeat;
  background-size: cover;

  margin: -20px 140px 0;
  padding: 40px 190px 140px;
  text-align: center;
  z-index: 2;

  @media (max-width: 600px) {
    padding: 40px 5px 140px;
    margin: 0;
  } ;
`;

const StyledTitle = styled(Title)``;
const StyledParagraph = styled(Paragraph)`
  margin: 40px;
  line-height: 1.6;
`;

const About = () => {
  return (
    <Wrapper image={ImageBgc} id="about">
      <StyledTitle type="h2">About</StyledTitle>

      <StyledParagraph type="text">
        Lorem ipsum dolor sit, amet consectetur adipisicing elit. Provident
        itaque pariatur tempore odit culpa veritatis magni assumenda totam id,
        labore exercitationem soluta. Vel, maiores ipsa delectus aut, optio
        culpa quidem ullam praesentium architecto magni eius fugit. Consectetur
        quas soluta expedita dicta excepturi iure hic? Rerum, cumque beatae
        magnam, officiis accusamus quas a repellat accusantium suscipit commodi,
        fugit fuga nulla deleniti!
      </StyledParagraph>
    </Wrapper>
  );
};

export default About;
