import { useState, useEffect } from "react";
import styled from "styled-components";
import { theme } from "../../../theme";

import Logo from "../../../assets/images/logo.png";

const Wrapper = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  display: grid;
  grid-template-columns: 1fr max-content 1fr;
  padding: ${({ scroll }) => (scroll ? "5px 30px" : "15px 30px")};

  transition: 0.3s ease-in-out;

  background-color: ${({ scroll }) =>
    scroll ? "rgba(0,0,0,.9)" : "transparent"};

  z-index: 99;

  @media (max-width: 600px) {
    grid-template-columns: 1fr;
  }
`;

const StyledUlLeft = styled.ul`
  list-style: none;

  display: flex;
  align-items: center;
  justify-content: flex-end;
  @media (max-width: 600px) {
    flex-direction: column;
  }
`;
const StyledUlRight = styled(StyledUlLeft)`
  justify-content: flex-start;
`;

const StyledLi = styled.li`
  padding: 0 30px;
  @media (max-width: 600px) {
    padding: 10px;
  }
`;

const StyledLinkLogo = styled.a`
  padding: 0 90px;
  @media (max-width: 600px) {
    order: -1;
  }
`;
const StyledLink = styled.a`
  color: ${theme.fontColors.primary};
  font-family: ${theme.fontFamily.secondary};
  font-weight: ${theme.fontWeight.medium};
  font-size: 20px;
  text-transform: uppercase;
  text-decoration: none;

  transition: 0.2s linear;

  :hover {
    color: ${theme.fontColors.textAddress};
  }
`;

const StyledImg = styled.img`
  width: 60%;
`;

const Nav = () => {
  const [scroll, setScroll] = useState(false);
  const [open, setOpen] = useState(false);

  useEffect(() => {
    window.onscroll = () => {
      if (window.pageYOffset > 10) {
        setScroll(true);
      } else {
        setScroll(false);
      }
    };
  }, []);

  return (
    <Wrapper scroll={scroll}>
      <StyledUlLeft>
        <StyledLi>
          <StyledLink href="#whynexus">Why Nexus?</StyledLink>
        </StyledLi>
        <StyledLi>
          <StyledLink href="#about">Features</StyledLink>
        </StyledLi>
      </StyledUlLeft>

      <StyledLinkLogo href="#" style={{ textAlign: "center" }}>
        <StyledImg src={Logo} alt="" />
      </StyledLinkLogo>
      <StyledUlRight>
        <StyledLi>
          <StyledLink href="#contact">Contact</StyledLink>
        </StyledLi>
        <StyledLi>
          <StyledLink href="#requestaquote">Get a quote</StyledLink>
        </StyledLi>
      </StyledUlRight>
    </Wrapper>
  );
};

export default Nav;
