import styled from "styled-components";

import Title from "../../atoms/Title/Title";
import Paragraph from "../../atoms/Paragraph/Paragraph";

import Img from "../../../assets/images/image-header-2.png";
import { theme } from "../../../theme";
import LinkArticle from "../../atoms/Link/LinkArticle";

const Wrapper = styled.div`
  display: grid;
  grid-template-columns: 1fr 1fr;
  background-color: ${theme.backgroundColors.secondary};

  :nth-of-type(even) > div:nth-child(1) {
    order: 1;
  }

  @media (max-width: 600px) {
    grid-template-columns: 1fr;
    padding: 40px;
    text-align: center;
  } ;
`;

const WrapperText = styled.div`
  width: 50%;
  display: flex;
  flex-direction: column;
  justify-content: center;

  margin: 0 auto;

  @media (max-width: 600px) {
    width: 100%;
  } ;
`;
const StyledTitle = styled(Title)``;
const StyledParagraph = styled(Paragraph)`
  line-height: 1.6;
  padding: 20px 0;
`;

const StyledLink = styled(LinkArticle)`
  height: 40px;

  text-transform: capitalize;
  margin: 0 0 0 auto;

  @media (max-width: 600px) {
    margin: 0 auto;
    width: 50%;
  } ;
`;

const WrapperImg = styled.div`
  @media (max-width: 600px) {
    display: none;
  } ;
`;

const StyledImg = styled.img`
  width: 100%;
`;

const WhyNexusElement = () => {
  return (
    <Wrapper>
      <WrapperText>
        <StyledTitle type="h3">{`Safe & Secure`}</StyledTitle>
        <StyledParagraph type="text">
          Lorem Ipsum Dolor Sit Amet, Consetetur Sadipscing Elitr, Sed Diam
          Nonumy Eirmod Tempor Invidunt.
        </StyledParagraph>
        <StyledLink href="#">Lorem ipsum</StyledLink>
      </WrapperText>
      <WrapperImg>
        <StyledImg src={Img} alt="" />
      </WrapperImg>
    </Wrapper>
  );
};

export default WhyNexusElement;
