import Input from "../../atoms/Input/Input";

import styled from "styled-components";
import Select from "../../atoms/Select/Select";
import TextArea from "../../atoms/TextArea";
import { theme } from "../../../theme";

const Wrapper = styled.form`
  width: 630px;
  margin: 0 auto;

  display: grid;
  grid-template-areas:
    "name phone"
    "email subject"
    "message message"
    "button button";
  grid-gap: 26px 33px;

  background-color: ${theme.backgroundColors.secondary};
  border-radius: 5px;
  padding: 50px;
  box-shadow: 0 0 6px 1px rgba(0, 0, 0, 0.18);

  @media (max-width: 600px) {
    grid-template-areas:
      "name"
      "phone"
      "email"
      "subject"
      "message"
      "button";
    width: 100%;
    padding: 60px 40px;
  } ;
`;

const StyledButton = styled.button`
  grid-area: button;
  padding: 10px 80px;
  border: 2px solid ${theme.fontColors.primary};
  border-radius: 5px;
  background-color: ${theme.fontColors.tertiary};
  color: ${theme.fontColors.primary};
  font-family: ${theme.fontFamily.secondary};
  text-transform: uppercase;
  font-size: 18px;
  cursor: pointer;

  transition: background-color 0.3s ease-in-out, color 0.3s ease-in-out,
    border 0.3s ease-in-out 0.15s;

  :hover {
    background-color: ${theme.fontColors.primary};
    color: ${theme.fontColors.tertiary};
    border: 2px solid ${theme.fontColors.tertiary};
  }
`;

const FormMessage = () => {
  return (
    <Wrapper>
      <Input name="name" />
      <Input name="phone" />
      <Input name="email" />
      <Input name="subject" />
      <TextArea name="message" />
      <StyledButton>Send Message</StyledButton>
    </Wrapper>
  );
};

export default FormMessage;
