import Input from "../../atoms/Input/Input";

import styled from "styled-components";
import Select from "../../atoms/Select/Select";
import TextArea from "../../atoms/TextArea";
import { theme } from "../../../theme";

const Wrapper = styled.form`
  position: relative;
  max-width: 1000px;
  margin: 0 auto;

  display: grid;
  grid-template-areas:
    "from to"
    "type email"
    "message message";
  grid-gap: 26px 33px;

  background-color: ${theme.backgroundColors.secondary};
  border-radius: 5px;
  padding: 50px 50px 100px;
  box-shadow: 0 0 6px 1px rgba(0, 0, 0, 0.18);

  @media (max-width: 600px) {
    grid-template-areas:
      "from"
      "to"
      "type"
      "email"
      "message"
      "button";
  }

  @media (max-width: 600px) {
    padding: 60px 40px;
  } ;
`;

const StyledButton = styled.button`
  position: absolute;
  bottom: 25px;
  right: 50px;
  padding: 10px 80px;
  border: 2px solid ${theme.fontColors.primary};
  border-radius: 5px;
  background-color: ${theme.fontColors.tertiary};
  color: ${theme.fontColors.primary};
  font-family: ${theme.fontFamily.secondary};
  text-transform: uppercase;
  font-size: 18px;
  cursor: pointer;

  transition: background-color 0.3s ease-in-out, color 0.3s ease-in-out,
    border 0.3s ease-in-out 0.15s;

  :hover {
    background-color: ${theme.fontColors.primary};
    color: ${theme.fontColors.tertiary};
    border: 2px solid ${theme.fontColors.tertiary};
  }

  @media (max-width: 600px) {
    grid-area: button;
    position: static;
  } ;
`;

const TitleForm = styled.h3`
  position: absolute;
  top: -35px;
  font-size: 26px;
  color: ${theme.fontColors.primary};
  font-family: ${theme.fontFamily.tertiary};
  font-weight: ${theme.fontWeight.regular};
  text-transform: uppercase;
  background-color: ${theme.fontColors.tertiary};

  padding: 10px 50px 5px;

  @media (max-width: 600px) {
    width: 100%;
    text-align: center;
  }
`;

const Form = () => {
  return (
    <Wrapper>
      <TitleForm>Request a quote</TitleForm>
      <Input name="from" />
      <Input name="to" />
      <Select
        name="type"
        options={["FTL - Full Truck Load", "LTL Less Than Truck Load"]}
      />
      <Input name="email" />
      <TextArea name="message" />
      <StyledButton>Send</StyledButton>
    </Wrapper>
  );
};

export default Form;
