import { useEffect, useState } from "react";
import styled, { keyframes } from "styled-components";

const opaAnim = keyframes`
from {opacity: 0}
to {opacity: 1}
`;
const opaAnim2 = keyframes`
from {opacity: 1}
to {opacity: 0}
`;

const Wrapper = styled.div`
  width: 100%;
  height: 100%;
`;

const StyledElement = styled.div`
  opacity: 0;
  /* display: none; */
  &.active {
    animation: ${opaAnim} 1s forwards;
  }
  &.over {
    animation: ${opaAnim2} 1s forwards;
  }

  :before {
    content: "";
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;

    background-image: url(${({ src }) => src});
    background-position: center;
    background-repeat: no-repeat;
    background-size: cover;
  }
`;

const Carusel = ({ elements }) => {
  const [activeImg, setActiveImg] = useState(0);

  const mapElements = elements.map((el, index) => (
    <StyledElement
      key={index}
      src={el}
      className={`carusel ${index === activeImg ? "active" : "over"}`}
    ></StyledElement>
  ));

  useEffect(() => {
    let number = 0;
    const interval = setInterval(() => {
      if (number === 2) {
        number = 0;
        setActiveImg(number);
      } else {
        number++;
        setActiveImg(number);
      }
    }, 10000);
    return () => clearInterval(interval);
  }, []);

  return (
    <Wrapper>
      {mapElements} <p>{activeImg}</p>
    </Wrapper>
  );
};

export default Carusel;
