import styled from "styled-components";

import { theme } from "../../../theme";

const StyledTitleH1 = styled.h1`
  color: ${theme.fontColors.primary};
  font-family: ${theme.fontFamily.primary};
  font-weight: ${theme.fontWeight.bold};
  font-size: 54px;

  @media (max-width: 600px) {
    font-size: 46px;
  } ;
`;
const StyledTitleH2 = styled.h2`
  color: ${theme.fontColors.tertiary};
  font-family: ${theme.fontFamily.primary};
  font-weight: ${theme.fontWeight.bold};
  font-size: 54px;
  text-transform: uppercase;
  @media (max-width: 600px) {
    font-size: 46px;
  } ;
`;
const StyledTitleH3 = styled.h3`
  color: ${theme.fontColors.secondary};
  font-family: ${theme.fontFamily.secondary};
  font-weight: ${theme.fontWeight.regular};
  font-size: 48px;
  text-transform: uppercase;
  @media (max-width: 600px) {
    font-size: 42px;
  } ;
`;

const Title = ({ children, className, type = "h1" }) => {
  if (type === "h1")
    return <StyledTitleH1 className={className}>{children}</StyledTitleH1>;
  if (type === "h2")
    return <StyledTitleH2 className={className}>{children}</StyledTitleH2>;
  if (type === "h3")
    return <StyledTitleH3 className={className}>{children}</StyledTitleH3>;
  else return null;
};

export default Title;
