import styled from "styled-components";

import { theme } from "../../../theme";

const StyledTextArea = styled.textarea`
  width: 100%;
  border: none;
  background-color: ${theme.backgroundColors.secondary};
  box-shadow: 0 0 6px 1px rgba(0, 0, 0, 0.18);
  padding: 15px 20px;
  border-radius: 5px;

  font-family: ${theme.fontFamily.tertiary};
  font-size: 21px;

  color: ${theme.fontColors.secondary};

  grid-area: ${({ name }) => name};

  ::placeholder {
    text-transform: capitalize;
  }
`;

const TextArea = ({ name }) => {
  return (
    <StyledTextArea name={name} placeholder={name} rows="3"></StyledTextArea>
  );
};

export default TextArea;
