import styled from "styled-components";

import { theme } from "../../../theme";

const StyledSelect = styled.select`
  border: none;
  background-color: ${theme.backgroundColors.secondary};
  box-shadow: 0 0 6px 1px rgba(0, 0, 0, 0.18);
  padding: 15px 20px;
  border-radius: 5px;
  font-family: ${theme.fontFamily.tertiary};
  font-size: 21px;

  color: ${theme.fontColors.secondary};

  grid-area: ${({ name }) => name};
`;

const StyledOption = styled.option`
  padding: 50px;
`;

const Select = ({ options, name }) => {
  return (
    <StyledSelect id={name} name={name}>
      {options.map((el) => (
        <StyledOption key={el} value={el}>
          {el}
        </StyledOption>
      ))}
    </StyledSelect>
  );
};

export default Select;
