import styled from "styled-components";

import { theme } from "../../../theme";

const StyledParagraphTitle = styled.p`
  color: ${theme.fontColors.primary};
  font-family: ${theme.fontFamily.primary};
  font-weight: ${theme.fontWeight.bold};
  font-size: 36px;

  @media (max-width: 600px) {
    font-size: 24px;
  } ;
`;
const StyledParagraphText = styled.p`
  color: ${theme.fontColors.secondary};
  font-family: ${theme.fontFamily.secondary};
  font-weight: ${theme.fontWeight.regular};
  font-size: 28px;
  @media (max-width: 600px) {
    font-size: 20px;
  } ;
`;

const Paragraph = ({ children, className, type = "title" }) => {
  if (type === "title") {
    return (
      <StyledParagraphTitle className={className}>
        {children}
      </StyledParagraphTitle>
    );
  }
  if (type === "text") {
    return (
      <StyledParagraphText className={className}>
        {children}
      </StyledParagraphText>
    );
  } else return null;
};

export default Paragraph;
