import styled, { css } from "styled-components";
import { theme } from "../../../theme";

import SVGArray from "../../../assets/svg/arrayTwo.svg";

const StyledLink = styled.a`
  border: none;
  border-bottom: 3px solid ${theme.fontColors.textAddress};
  color: ${theme.fontColors.textAddress};
  text-transform: uppercase;
  font-family: ${theme.fontFamily.secondary};
  font-weight: ${theme.fontWeight.medium};
  background-color: transparent;
  font-size: 20px;
  text-decoration: none;

  display: flex;
  align-items: center;

  width: max-content;

  transition: 0.2s ease-in-out;
  :hover {
    border-bottom: 3px solid ${theme.fontColors.secondary};
    color: ${theme.fontColors.secondary};
  }
`;

const StyledImg = styled.img`
  padding-left: 25px;
`;

const LinkArticle = ({ children, className, href, type }) => {
  return (
    <StyledLink type={type} href={href} className={className}>
      {children} <StyledImg src={SVGArray} alt="" />
    </StyledLink>
  );
};

export default LinkArticle;
