import styled, { css } from "styled-components";
import { theme } from "../../../theme";

import SVGArray from "../../../assets/svg/array.svg";

const StyledLink = styled.a`
  border: none;
  border-bottom: 3px solid ${theme.fontColors.primary};
  color: ${theme.fontColors.primary};
  text-transform: uppercase;
  font-family: ${theme.fontFamily.secondary};
  font-weight: ${theme.fontWeight.medium};
  background-color: transparent;
  font-size: 36px;
  text-decoration: none;

  display: flex;
  align-items: center;

  width: max-content;

  padding: 5px 25px;

  transition: 0.3s ease-in-out;

  :hover {
    border-bottom: 3px solid ${theme.fontColors.tertiary};
    color: ${theme.fontColors.tertiary};
  }

  ${({ type }) =>
    type === "button" &&
    css`
      border: none;
      border-radius: 10px;
      background-color: ${theme.backgroundColors.button};
      padding: 15px 25px;

      :hover {
        border: none;
        background-color: ${theme.backgroundColors.button};
        color: ${theme.fontColors.primary};
        transform: scale(1.05);
      }
    `}
`;

const StyledImg = styled.img`
  padding-left: 25px;
`;

const Link = ({ children, className, href, type }) => {
  return (
    <StyledLink type={type} href={href} className={className}>
      {children} <StyledImg src={SVGArray} alt="" />
    </StyledLink>
  );
};

export default Link;
